<?php
/**
 * @package web-rtpslot
 * @since 1.0.0
 */

define( 'EXCPATH', dirname( __FILE__ ) );

date_default_timezone_set( 'Asia/Jakarta' );

function get_component( $file = '' ) {
    if ( file_exists( EXCPATH . '/' . $file . '.php' ) ) {
        require_once EXCPATH . '/' . $file . '.php';
    }
}

function tanggal_indo( $tanggal, $cetak_hari = true )
{
	$hari = array ( 1 =>    'Senin',
				'Selasa',
				'Rabu',
				'Kamis',
				'Jumat',
				'Sabtu',
				'Minggu'
			);
			
	$bulan = array (1 =>   'Januari',
				'Februari',
				'Maret',
				'April',
				'Mei',
				'Juni',
				'Juli',
				'Agustus',
				'September',
				'Oktober',
				'November',
				'Desember'
			);
	$split 	  = explode('-', $tanggal);
	$tgl_indo = $split[2] . ' ' . $bulan[ (int)$split[1] ] . ' ' . $split[0];
	
	if ($cetak_hari) {
		$num = date('N', strtotime($tanggal));
		return $hari[$num] . ', ' . $tgl_indo;
	}
	return $tgl_indo;
}
